dataDir = "D:/Qifang/Phophatase_docking/peptidedock/data/";
dataFile = paste(dataDir, "EPXXXPR_EP_dist.txt", sep='');
distERDataFram = read.table (dataFile, header=T, sep='\t');

distDataAll = c(distERDataFram$OE1.NH1, distERDataFram$OE1.NH2, distERDataFram$OE2.NH1, distERDataFram$OE2.NH2);
distDensityAll = density(distDataAll);

figFile = paste(dataDir, "EPXXXPR_EP_dist_density.png", sep='');
png(figFile, width=2048, height=2048, res = 300);
plot(distDensityAll, main='Density of OE-NH Distances', xlab='Distance', ylab='Frequency');
points(c(27.5), y=c(0), pch=19, col='red');
dev.off();

distDataFile = paste(dataDir, "EPXXXPR_ER_pairfit_dist.txt", sep='');
distOeNhDataFram = read.table (distDataFile, header=T, sep='\t');

distOeMin = pmin(distOeNhDataFram$OE1, distOeNhDataFram$OE2);
distNhMin = pmin(distOeNhDataFram$NH1, distOeNhDataFram$NH2);
distOeNhMinSum = distOeMin + distNhMin;
distOeNhMinSumDensity = density(distOeNhMinSum, bw=0.5);
figFile = paste(dataDir, "MinOEMinNHDensity_05.png", sep='');
png(figFile, width=2048, height=2048, res=300);
plot(distOeNhMinSumDensity, main="Density of Min(OE1/2) + Min(NH1/2)", xlab='Distance', ylab='Frequency');
points(c(min(distOeNhMinSum), max(distOeNhMinSum)), y = c(0, 0), pch=19, col='red');
dev.off();
